﻿<%
'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Function CacheInitialize()
	Application.Lock
	Application("LoadLevel")         = 0
	Application("BufferUpdateTime")  = Now()
	Application("OnlineNum")         = 0
	Application.UnLock

	CacheSet()
	CacheArticleClass()
	CacheNewArticle()
	CacheRndArticle()
	CacheNewComment()
	CacheNewGuestbook()
	CacheLink()
	CacheMenu()
	Cache_Widget()
	CacheHotArticle()
	CacheSideCount()
End Function
'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheSet()
	'打开数据库连接
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select * from " & PrefixStr & "Set", Conn, 1, 1

	Application.Lock
	Application("BlogSet") = Rs.GetRows( Rs.RecordCount )
	Application.UnLock

	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheArticleClass()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	'Rs.Open "select distinct(Class) from " & PrefixStr & "Article where IsDel=False order by Class asc", Conn, 1, 1
	Rs.Open "select Name,ArticleNum,Description from " & PrefixStr & "Sort order by Num asc,SID desc", Conn, 1, 1
		If Rs.RecordCount > 0 Then
			Application.Lock
			Application("SideArticleClass") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheNewArticle()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select top 6 ID,Title,Type,Address,Class from " & PrefixStr & "Article where IsDel=False order by ID desc", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("SideNewArticle") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheHotArticle()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select top 6 ID,Title,Type,Address,Class from " & PrefixStr & "Article where IsDel=False order by Comment desc,[Read] desc", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("SideHotArticle") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheRndArticle()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Randomize
	Rs.Open "select top 6 ID,Title,Type,Address,Class from " & PrefixStr & "Article where IsDel=False order by Rnd(-(ID +" & Rnd() & "))", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("SideRndArticle") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheNewComment()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select top 6 C.Comment, C.ArticleID, A.ID, A.Type, A.Address, A.Class, A.Title, C.Author from " & PrefixStr & "Comment as C, " & PrefixStr & "Article as A where C.ArticleID=A.ID and C.IsDel=False and C.IsShow=True and A.IsDel=False order by C.CID desc", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("SideNewComment") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheNewGuestbook()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select top 6 GID,Guestbook,Author from " & PrefixStr & "Guestbook where IsDel=False and IsShow=True order by GID Desc", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("SideNewGuestbook") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheLink()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select Title,Description,Address from " & PrefixStr & "Link where IsDel=False order by LID Asc", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("SideLink") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheMenu()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select Name,Title,Type,Address from " & PrefixStr & "Menu order by Num Asc,MID Desc", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("MenuItem") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：Cache_Widget()
' 作用：
'--------------------------------------------
Sub Cache_Widget()
	Set Rs = Server.CreateObject("Adodb.RecordSet")
	Rs.Open "select Name,Title,[Function] from " & PrefixStr & "Widget order by WID Desc", Conn, 1, 1
		If Not ( Rs.EOF And Rs.BOF ) Then
			Application.Lock
			Application("WidgetItem") = Rs.GetRows( -1 )
			Application.UnLock
		End If
	Rs.Close
	Set Rs = Nothing
	QueryNum = QueryNum + 1
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheSideCount()
	Application.Lock
	Application("SideArticleNum") = Data_Execute( "select count(ID) from " & PrefixStr & "Article where IsDel=False" )(0)
	Application("SideCommentNum") = Data_Execute( "select count(CID) from " & PrefixStr & "Comment where IsDel=False" )(0)
	Application("SideGuestbookNum") = Data_Execute( "select count(GID) from " & PrefixStr & "Guestbook where IsDel=False" )(0)
	Application("SideUserNum") = Data_Execute( "select count(UID) from " & PrefixStr & "User where IsDel=False" )(0)
	Application.UnLock
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheOnlineNum()
	Dim tmp(),freshTime,flg,num,id,i
	freshTime = 300 '登录过期时间,单位秒
	flg = False

	Application.Lock

	If Application("OnlineNum") = 0 Or Isempty( Application("OnlineNum") ) or Isempty( Application("UserSessionID") ) then
		Application("OnlineNum") = 1
		ReDim tmp(0)
		tmp(0) = Session.SessionID
		Application("UserSessionID")=tmp
		Application("UserSessionID" & Session.SessionID) = Now() '记录访问时间
	Else
		For i = LBound( Application("UserSessionID") ) to Ubound( Application("UserSessionID") )
			If Application("UserSessionID")(i) = Session.SessionID Then 
				Application("userSessionID" & Session.SessionID) = Now()
				flg = True
			End If
		Next
		If flg <> True then 
			ReDim tmp( UBound( Application("UserSessionID") ) )
			For i = LBound( Application("UserSessionID") ) To UBound( Application("UserSessionID") )
				tmp(i) = Application("UserSessionID")(i)
			Next 
			ReDim Preserve tmp( UBound( Application("UserSessionID") ) + 1 )
			tmp( UBound( Application("UserSessionID") ) + 1 ) = Session.SessionID
			Application("UserSessionID" & session.SessionID) = Now()
			Application("UserSessionID") = tmp '新数组 存入application 
			Application("OnlineNum") = Application("OnlineNum") + 1
		End If
	End If

	num = 0
	ReDim tmp( UBound( Application("UserSessionID") ) )
	For i = 0 to UBound( Application("UserSessionID") ) '去掉超时session.SessionID
		id = Application("UserSessionID")(i)
		If DateDiff( "s", Application("UserSessionID" & id), Now() ) < freshTime Then
			tmp(num) = Application("UserSessionID")(i)
			num = num + 1
		Else
			Application.Contents.Remove("UserSessionID" & id)
		End If
	Next
	If num <> Application("OnlineNum") Then
		ReDim Preserve tmp(num - 1)
		Application.Contents.Remove("UserSessionID")
		Application("UserSessionID") = tmp
		Application("OnlineNum") = num
	End If
	Application.UnLock()
End Sub

'--------------------------------------------
' 名称：
' 作用：
'--------------------------------------------
Sub CacheLoadSet()
	BlogName          = Application("BlogSet")(0, 0)
	If IsNull( BlogName ) Then BlogName = ""
	BlogDescription   = Application("BlogSet")(1, 0)
	If IsNull( BlogDescription ) Then BlogDescription = ""
	BlogKeyWords      = Application("BlogSet")(2, 0)
	If IsNull( BlogKeyWords ) Then BlogKeyWords = ""
	BlogBeiAn         = Application("BlogSet")(3, 0)
	If IsNull( BlogBeiAn ) Then BlogBeiAn = ""
	BlogDomain        = Application("BlogSet")(4, 0)
	If IsNull( BlogDomain ) Then BlogDomain = ""
	SideBuildDate     = Application("BlogSet")(5, 0)
	SideVisitNum      = Application("BlogSet")(6, 0)
	SideTodayVisitNum = Application("BlogSet")(7, 0)
	BlogMaxPerPage    = Application("BlogSet")(8, 0)
	BlogMaxOnline     = Application("BlogSet")(9, 0)
	BlogFilterWords   = Application("BlogSet")(10, 0)
	If IsNull( BlogFilterWords ) Then BlogFilterWords = ""
	BlogNameFilter    = Application("BlogSet")(11, 0)
	If IsNull( BlogNameFilter ) Then BlogNameFilter = ""
	BlogEnable        = Application("BlogSet")(12, 0)
	BlogCloseReason   = Application("BlogSet")(13, 0)
	BlogRegEnable     = Application("BlogSet")(14, 0)
	BlogComment       = Application("BlogSet")(15, 0)
	BlogComTimer      = Application("BlogSet")(16, 0)
	BlogComMaxLength  = Application("BlogSet")(17, 0)
	BlogArtMaxLength  = Application("BlogSet")(18, 0)
	BlogArtType       = Application("BlogSet")(19, 0)
	BlogShowType      = Application("BlogSet")(20, 0)
	BlogVerify        = Application("BlogSet")(21, 0)
	BlogVersion       = Application("BlogSet")(22, 0)
	BlogStyle         = Application("BlogSet")(23, 0)
	BlogDesigner      = "星空泪"
	If BlogMaxOnline < 5 Then
		BlogMaxOnline = 5
	End If
	SideArticleClass  = Application("SideArticleClass")
	SideNewArticle    = Application("SideNewArticle")
	SideHotArticle    = Application("SideHotArticle")
	SideRndArticle    = Application("SideRndArticle")
	SideNewComment    = Application("SideNewComment")
	SideNewGuestbook  = Application("SideNewGuestbook")
	SideLink          = Application("SideLink")
	MenuItem          = Application("MenuItem")
	WidgetItem        = Application("WidgetItem")
	SideArticleNum    = Application("SideArticleNum")
	SideCommentNum    = Application("SideCommentNum")
	SideGuestbookNum  = Application("SideGuestbookNum")
	SideUserNum       = Application("SideUserNum")
	OnlineNum         = Application("OnlineNum")
End Sub
%>